package org.msh.tb.bd.tbforms.dhis2;

import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.dhis2.data.AuthResponse;
import org.msh.utils.JsonUtils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Base64;

/**
 * Created by Mauricio on 27/01/2017.
 * Service that sends gets DHIS2 credentials used during information exportation.
 */
@Name("dHIS2AuthenticationService")
public class DHIS2AuthenticationService extends DHIS2RequestService {

    private final String AUTH_API_URL = "/uaa/oauth/token";

    /**
     * Requests credentials to DHIS2 based on configuration in SystemConfig
     * @return
     * @throws IOException
     */
    public AuthResponse auth() throws IOException {
        // mount URL params string
        String urlParams = "grant_type=password&username=[USER_NAME]&password=[USER_PASSWORD]";
        urlParams = urlParams.replace("[USER_NAME]", etbmanagerApp.getConfiguration().getDhis2User());
        urlParams = urlParams.replace("[USER_PASSWORD]", etbmanagerApp.getConfiguration().getDhis2Password());

        // mount authorization string
        String oAuth2 = etbmanagerApp.getConfiguration().getDhis2OAuth2();
        byte[] encodedBytes;
        encodedBytes = Base64.getEncoder().encode(oAuth2.getBytes());
        String authorization = "Basic " + new String(encodedBytes);

        AuthResponse ret = null;
        HttpURLConnection conn = null;

        try {
            // get connection
            conn = super.getPostConnection(AUTH_API_URL, urlParams, authorization);

            // request
            checkHttpCode(conn.getResponseCode());

            // read response
            ret = JsonUtils.parse(conn.getInputStream(), AuthResponse.class);

        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        return ret;
    }

}
